<?php
require "config.php";
if(isset($_SESSION['user'])) {
	header("location: ".BASE_URL.'u/'.$_SESSION['user']['username'].'/view');
	exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="<?=$meta_description_home?>">
    <meta name="author" content="NodeTent">
    <title><?=$meta_title_home?></title>
    <link rel="shortcut icon" href="<?php echo BASE_URL; ?>assets/img/<?=$favicon?>" type="image/x-icon">
    <link href="<?php echo BASE_URL; ?>assets/css/bootstrap.min.css" rel="stylesheet">
    <link href="<?php echo BASE_URL; ?>assets/css/style.css" rel="stylesheet">
	<link href="<?php echo BASE_URL; ?>assets/css/vendor.css" rel="stylesheet">
	<?=$header?>
</head>
<body>
	<div id="loader_form">
		<div data-loader="circle-side-2"></div>
	</div>
	<div class="container-fluid full-height">
		<div class="row row-height">
			<div class="col-lg-6 content-left">
				<div class="content-left-wrapper">
					<div>
						<figure><img src="<?php echo BASE_URL; ?>assets/img/home.svg" alt="" class="img-fluid"></figure>
						<h2>Welcome to Mystiko</h2>
						<p>Mystiko is an interactive anonymous messaging web app based on a dare game. Start by creating your profile and sharing your link to all your friends and contacts to know what your friends think about you. With the help of Mystiko, you can send and recieve anonymous compliments easily for free!</p>
						<a href="login" class="btn_1 rounded">Login</a>
						<a href="login" class="btn_1 rounded mobile_btn">Login</a>
					</div>
					<div class="copy">© 2021 Mystiko</div>
				</div>
				<!-- /content-left-wrapper -->
			</div>
			<!-- /content-left -->

			<div class="col-lg-6 content-right" id="start">
				<div id="wizard_container">
					<div id="top-wizard">
							<div id="progressbar"></div>
						</div>
						<!-- /top-wizard -->
						<form id="wrapped" method="POST">
							<div id="middle-wizard">
								<div class="step">
									<h3 class="main_question"><strong>1/3</strong>Please fill with your details</h3>
									<div class="form-group">
										<input type="text" name="first_name" id="fn" class="form-control required" placeholder="First Name">
									</div>
									<div class="form-group">
										<input type="text" name="last_name" id="ln" class="form-control required" placeholder="Last Name">
									</div>
									<div class="form-group">
										<input type="email" name="email" id="em" class="form-control required" placeholder="Your Email">
									</div>
									<div class="form-group terms">
										<label class="container_check">Please accept our <a href="#" data-toggle="modal" data-target="#terms-txt">Terms and conditions</a>
											<input type="checkbox" name="terms" value="Yes" class="required">
											<span class="checkmark"></span>
										</label>
									</div>
								</div>
								<!-- /step-->
								<div class="step">
									<h3 class="main_question"><strong>2/3</strong>Plase provide your account details</h3>
									<div class="form-group">
										<input type="text" name="user_name" id="un" class="form-control required" placeholder="User name">
									</div>
									<div class="form-group">
										<input class="form-control required" type="password" id="password1" name="password1" placeholder="Password">
									</div>
									<div class="form-group">
										<input class="form-control required" type="password" id="password2" name="password2" placeholder="Confirm Password">
									</div>
									<div id="pass-info" class="clearfix"></div>
								</div>
								<!-- /step-->
								<div class="submit step">
									<h3 class="main_question"><strong>3/3</strong>Summary</h3>
									<div class="summary">
										<ul>
											<li><strong>1</strong>
												<h5>Personal Details</h5>
												<ul>
													<li><label>First Name</label>: <span id="first_name"></span></li>
													<li><label>Last Name</label>: <span id="last_name"></span></li>
													<li><label>Email</label>: <span id="email"></span></li>
												</ul>
											</li>
											<li><strong>2</strong>
												<h5>Account Details</h5>
												<ul>
													<li><label>User Name</label>: <span id="user_name"></span></li>
													<li><label>Password</label>: <span id="password"></span></li>
												</ul>
											</li>
										</ul>
									</div>
								</div>
								<!-- /step-->
							</div>
							<!-- /middle-wizard -->
							<div id="bottom-wizard">
								<button type="button" name="backward" class="backward">Prev</button>
								<button type="button" name="forward" class="forward">Next</button>
								<button type="submit" name="process" class="submit">Submit</button>
							</div>
							<!-- /bottom-wizard -->
						</form>
					</div>
					<!-- /Wizard container -->
			</div>
			<!-- /content-right-->
		</div>
		<!-- /row-->
	</div>
	<!-- /container-fluid -->

	<div class="cd-overlay-nav">
		<span></span>
	</div>
	<!-- /cd-overlay-nav -->

	<div class="cd-overlay-content">
		<span></span>
	</div>
	<!-- /cd-overlay-content -->
	
	<!-- Modal terms -->
	<div class="modal fade" id="terms-txt" tabindex="-1" role="dialog" aria-labelledby="termsLabel" aria-hidden="true">
		<div class="modal-dialog modal-dialog-centered">
			<div class="modal-content">
				<div class="modal-header">
					<h4 class="modal-title" id="termsLabel">Terms and conditions</h4>
					<button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
				</div>
				<div class="modal-body">
					<p>Mystiko is an interactive dare game developed by NodeTent where users can create an accont and get complimented, resented by friends, family and the closed ones keeping the privacy of the users safe.</p>
					<p>We care for the privacy & protection of our users and their data and we would like to share with you our policy and practices regarding your information and its privacy.</p>
					<p>Our Privacy Policy outlines what data is collected from our users and how it is used and processed. It also highlights how our users can control their data.</p>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn_1" data-dismiss="modal">Close</button>
				</div>
			</div>
			<!-- /.modal-content -->
		</div>
		<!-- /.modal-dialog -->
	</div>
	<!-- /.modal -->
	<script src="<?php echo BASE_URL; ?>assets/js/jquery.min.js"></script>
    <script src="<?php echo BASE_URL; ?>assets/js/vendor.min.js"></script>
	<script src="<?php echo BASE_URL; ?>assets/js/velocity.min.js"></script>
	<script src="<?php echo BASE_URL; ?>assets/js/main.js"></script>
	<?=$footer?>
</body>
</html>